//
//  Contacts.swift
//  Integration
//
//  Created by NurWork on 23/11/15.
//  Copyright © 2015 RWTH Aachen Univesity. All rights reserved.
//

import UIKit
import Contacts
import ContactsUI

class ContactsViewController: UIViewController, CNContactPickerDelegate, CNContactViewControllerDelegate {

    var store = CNContactStore()
    var contacts: [CNContact] = []
  
    override func viewDidLoad() {
        super.viewDidLoad()

        navigationItem.title = "Contacts"
        //navigationItem.leftBarButtonItem = UIBarButtonItem(title: "Show Contacts", style: .Bordered, target: self, action: "showContacts")
        let addButton = UIBarButtonItem(barButtonSystemItem: .Add, target: self, action: "addContact")
        let showButton = UIBarButtonItem(title: "Show All", style: .Plain, target: self, action: "showContacts")

        navigationItem.rightBarButtonItems = [addButton,showButton]
    }

    
   

    func showContacts()
    {
        let contactPickerViewController = CNContactPickerViewController()
        contactPickerViewController.delegate = self
        presentViewController(contactPickerViewController, animated: true, completion: nil)
    }
    
    func addContact()
    {
        /*
        let contact = CNContact().mutableCopy() as! CNMutableContact
        var contactController = CNContactViewController(forNewContact: contact)
        contactController.contactStore = store
        contactController.delegate = self
        
        navigationController?.pushViewController(contactController, animated: true)
        */
        let newContact = CNMutableContact()
        newContact.givenName = "Nur"
        newContact.middleName = ""
        newContact.nickname = "Nur"
        
        /*
        if let image = UIImage(named: "..."),let data = UIImagePNGRepresentation(image)
        {
                newContact.imageData = data
        }
        */
        
        let phone = CNLabeledValue(label: CNLabelWork, value:CNPhoneNumber(stringValue: "+4911111111"))
        newContact.phoneNumbers = [phone]
        
        let email = CNLabeledValue(label: CNLabelWork, value:"hamdan@cs.rwth-aachen.de")
        newContact.emailAddresses = [email]
        
        newContact.jobTitle = "Research Assistant"
        newContact.organizationName = "RWTH"
        newContact.departmentName = "Media Group"
        
        let facebookProfile = CNLabeledValue(label: "Facebook", value: CNSocialProfile(urlString: "https://www.facebook.com/hamdan", username: "Nur", userIdentifier: "nur", service: CNSocialProfileServiceFacebook))
        
        newContact.socialProfiles = [facebookProfile]
        
        let aimProfile = CNLabeledValue(label: "AIM", value: CNInstantMessageAddress(username: "Nur", service: CNInstantMessageServiceAIM))
        newContact.instantMessageAddresses = [aimProfile]
        
        let birthday = NSDateComponents()
        birthday.year = 1987
        birthday.month = 1
        birthday.day = 1
        newContact.birthday = birthday
        
        
        let request = CNSaveRequest()
        request.addContact(newContact, toContainerWithIdentifier: nil)
        do{
            try store.executeSaveRequest(request)
        } catch let error{
            print(error)
        }
        
    }
   
   
    
    
    //MARK: Delegation
    
    func contactViewController(viewController: CNContactViewController, didCompleteWithContact contact: CNContact?) {

        self.navigationController?.popViewControllerAnimated(true)
    }
    
}
